DROP INDEX DNS.ATHLVLCOD_UK;

CREATE UNIQUE INDEX DNS.ATHLVLCOD_UK ON DNS.AUTHENTICATION_LEVEL
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ATHLVLNAM_UK;

CREATE UNIQUE INDEX DNS.ATHLVLNAM_UK ON DNS.AUTHENTICATION_LEVEL
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ATHLVL_H_PK;

CREATE UNIQUE INDEX DNS.ATHLVL_H_PK ON DNS.AUTHENTICATION_LEVEL_H
(AUTHENTICATION_LVL_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ATHLVL_PK;

CREATE UNIQUE INDEX DNS.ATHLVL_PK ON DNS.AUTHENTICATION_LEVEL
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ENRFRMTYPCOD_UK;

CREATE UNIQUE INDEX DNS.ENRFRMTYPCOD_UK ON DNS.ENROLLMENT_FORM_TYPE
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ENRFRMTYPNAM_UK;

CREATE UNIQUE INDEX DNS.ENRFRMTYPNAM_UK ON DNS.ENROLLMENT_FORM_TYPE
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ENRFRMTYP_H_PK;

CREATE UNIQUE INDEX DNS.ENRFRMTYP_H_PK ON DNS.ENROLLMENT_FORM_TYPE_H
(ENROLLMENT_FORM_TYP_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.ENRFRMTYP_PK;

CREATE UNIQUE INDEX DNS.ENRFRMTYP_PK ON DNS.ENROLLMENT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPDATA_PK;

CREATE UNIQUE INDEX DNS.DNSENRAPPDATA_PK ON DNS.DNS_ENROLLMENT_APP_DATA
(DNS_ENROLLMENT_APP_DATA_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPDAT_DNSENRAPP_FK_I;

CREATE INDEX DNS.DNSENRAPPDAT_DNSENRAPP_FK_I ON DNS.DNS_ENROLLMENT_APP_DATA
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPSTATCOD_UK;

CREATE UNIQUE INDEX DNS.DNSENRAPPSTATCOD_UK ON DNS.DNS_ENROLLMENT_APP_STATUS
(CODE)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPSTATNAM_UK;

CREATE UNIQUE INDEX DNS.DNSENRAPPSTATNAM_UK ON DNS.DNS_ENROLLMENT_APP_STATUS
(NAME)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPSTAT_H_PK;

CREATE UNIQUE INDEX DNS.DNSENRAPPSTAT_H_PK ON DNS.DNS_ENROLLMENT_APP_STATUS_H
(DNS_ENROLLMENT_APP_STAT_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPPSTAT_PK;

CREATE UNIQUE INDEX DNS.DNSENRAPPSTAT_PK ON DNS.DNS_ENROLLMENT_APP_STATUS
(DNS_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_ATHLVL_FK_I;

CREATE INDEX DNS.DNSENRAPP_ATHLVL_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_ENRFRMTYP_FK_I;

CREATE INDEX DNS.DNSENRAPP_ENRFRMTYP_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_H_PK;

CREATE UNIQUE INDEX DNS.DNSENRAPP_H_PK ON DNS.DNS_ENROLLMENT_APPLICATION_H
(DNS_ENROLLMENT_APP_H_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_PK;

CREATE UNIQUE INDEX DNS.DNSENRAPP_PK ON DNS.DNS_ENROLLMENT_APPLICATION
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE S_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_PRSN_FK_I;

CREATE INDEX DNS.DNSENRAPP_PRSN_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_VETIDTYP_FK_I;

CREATE INDEX DNS.DNSENRAPP_VETIDTYP_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSENRAPP_DNSENRAPPSTA_FK_I;

CREATE INDEX DNS.DNSENRAPP_DNSENRAPPSTA_FK_I ON DNS.DNS_ENROLLMENT_APPLICATION
(DNS_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE M_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSRSB_PK;

CREATE UNIQUE INDEX DNS.DNSRSB_PK ON DNS.DNS_RESUBMISSION
(DNS_RESUBMISSION_ID)
LOGGING
TABLESPACE L_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX DNS.DNSRSB_DNSENRAPP_FK_I;

CREATE INDEX DNS.DNSRSB_DNSENRAPP_FK_I ON DNS.DNS_RESUBMISSION
(DNS_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE L_DNS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
